<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @help_topics/node.creating_content.html.twig */
class __TwigTemplate_6b9c804871aa38f2a6b47c3f0a668279 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
        $this->sandbox = $this->extensions[SandboxExtension::class];
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 8
        $context["content_link_text"] = ('' === $tmp = \Twig\Extension\CoreExtension::captureOutput((function () use (&$context, $macros, $blocks) {
            // line 9
            yield "  ";
            yield t("Content", []);
            yield from [];
        })())) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 11
        $context["content_link"] = $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar($this->extensions['Drupal\help\HelpTwigExtension']->getRouteLink(($context["content_link_text"] ?? null), "system.admin_content"));
        // line 12
        $context["content_permissions_link_text"] = ('' === $tmp = \Twig\Extension\CoreExtension::captureOutput((function () use (&$context, $macros, $blocks) {
            // line 13
            yield "  ";
            yield t("Access the Content overview page", []);
            yield from [];
        })())) ? '' : new Markup($tmp, $this->env->getCharset());
        // line 15
        $context["content_permissions_link"] = $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar($this->extensions['Drupal\help\HelpTwigExtension']->getRouteLink(($context["content_permissions_link_text"] ?? null), "user.admin_permissions.module", ["modules" => "node"]));
        // line 16
        $context["content_overview_topic"] = $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar($this->extensions['Drupal\help\HelpTwigExtension']->getTopicLink("node.overview"));
        // line 17
        yield "<h2>";
        yield t("Goal", []);
        yield "</h2>
<p>";
        // line 18
        yield t("Create and publish a content item. See @content_overview_topic for more about content types and content items.", ["@content_overview_topic" => $this->env->getExtension(\Drupal\Core\Template\TwigExtension::class)->renderVar(($context["content_overview_topic"] ?? null)), ]);
        yield "</p>
<h2>";
        // line 19
        yield t("Who can create content?", []);
        yield "</h2>
<p>";
        // line 20
        yield t("Users with the <em>@content_permissions_link</em> permission can visit the <em>Content</em> page as described in this topic. Each content type has its own create permissions. For example, to create content of type Article, a user would need the Article: Create new content permission. In addition, users with the <em>Bypass content access control</em> or <em>Administer content</em> permission can create content items of all types. Some contributed modules change the permission structure for creating content.", ["@content_permissions_link" => $this->env->getExtension(\Drupal\Core\Template\TwigExtension::class)->renderVar(($context["content_permissions_link"] ?? null)), ]);
        yield "</p>
<h2>";
        // line 21
        yield t("Steps", []);
        yield "</h2>
<ol>
  <li>";
        // line 23
        yield t("In the <em>Manage</em> administrative menu, navigate to <em>@content_link</em>.", ["@content_link" => $this->env->getExtension(\Drupal\Core\Template\TwigExtension::class)->renderVar(($context["content_link"] ?? null)), ]);
        yield "</li>
  <li>";
        // line 24
        yield t("Click <em>Add content</em>.", []);
        yield "</li>
  <li>";
        // line 25
        yield t("If there is more than one content type defined on your site that you have permission to create, click the name of the type of content you want to create.", []);
        yield "</li>
  <li>";
        // line 26
        yield t("On the content edit form, enter the <em>Title</em> of your content, which will show as the page title when the content item is displayed on a page, and also as the label for the content item in administration screens.", []);
        yield "</li>
  <li>";
        // line 27
        yield t("Fill in the other fields shown on the edit form for this specific content type.", []);
        yield "</li>
  <li>";
        // line 28
        yield t("Leave the <em>Published</em> field checked to publish the content immediately, or uncheck it to make it unpublished. Unpublished content is generally not shown to non-administrative site users.", []);
        yield "</li>
  <li>";
        // line 29
        yield t("Optionally, click <em>Preview</em> to preview the content.", []);
        yield "</li>
  <li>";
        // line 30
        yield t("Click <em>Save</em>. You will see the content displayed on a page.", []);
        yield "</li>
</ol>
<h2>";
        // line 32
        yield t("Additional resources", []);
        yield "</h2>
<ul>
  <li><a href=\"https://www.drupal.org/docs/user_guide/en/content-chapter.html\">";
        // line 34
        yield t("Basic Page Management (Drupal User Guide)", []);
        yield "</a></li>
  <li><a href=\"https://www.drupal.org/docs/user_guide/en/content-create.html\">";
        // line 35
        yield t("Creating a Content Item (Drupal User Guide)", []);
        yield "</a></li>
</ul>";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@help_topics/node.creating_content.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  128 => 35,  124 => 34,  119 => 32,  114 => 30,  110 => 29,  106 => 28,  102 => 27,  98 => 26,  94 => 25,  90 => 24,  86 => 23,  81 => 21,  77 => 20,  73 => 19,  69 => 18,  64 => 17,  62 => 16,  60 => 15,  55 => 13,  53 => 12,  51 => 11,  46 => 9,  44 => 8,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% line 8 %}{% set content_link_text %}
  {% trans %}Content{% endtrans %}
{% endset %}
{% set content_link = render_var(help_route_link(content_link_text, 'system.admin_content')) %}
{% set content_permissions_link_text %}
  {% trans %}Access the Content overview page{% endtrans %}
{% endset %}
{% set content_permissions_link = render_var(help_route_link(content_permissions_link_text, 'user.admin_permissions.module', {'modules': 'node'})) %}
{% set content_overview_topic = render_var(help_topic_link('node.overview')) %}
<h2>{% trans %}Goal{% endtrans %}</h2>
<p>{% trans %}Create and publish a content item. See {{ content_overview_topic }} for more about content types and content items.{% endtrans %}</p>
<h2>{% trans %}Who can create content?{% endtrans %}</h2>
<p>{% trans %}Users with the <em>{{ content_permissions_link }}</em> permission can visit the <em>Content</em> page as described in this topic. Each content type has its own create permissions. For example, to create content of type Article, a user would need the Article: Create new content permission. In addition, users with the <em>Bypass content access control</em> or <em>Administer content</em> permission can create content items of all types. Some contributed modules change the permission structure for creating content.{% endtrans %}</p>
<h2>{% trans %}Steps{% endtrans %}</h2>
<ol>
  <li>{% trans %}In the <em>Manage</em> administrative menu, navigate to <em>{{ content_link }}</em>.{% endtrans %}</li>
  <li>{% trans %}Click <em>Add content</em>.{% endtrans %}</li>
  <li>{% trans %}If there is more than one content type defined on your site that you have permission to create, click the name of the type of content you want to create.{% endtrans %}</li>
  <li>{% trans %}On the content edit form, enter the <em>Title</em> of your content, which will show as the page title when the content item is displayed on a page, and also as the label for the content item in administration screens.{% endtrans %}</li>
  <li>{% trans %}Fill in the other fields shown on the edit form for this specific content type.{% endtrans %}</li>
  <li>{% trans %}Leave the <em>Published</em> field checked to publish the content immediately, or uncheck it to make it unpublished. Unpublished content is generally not shown to non-administrative site users.{% endtrans %}</li>
  <li>{% trans %}Optionally, click <em>Preview</em> to preview the content.{% endtrans %}</li>
  <li>{% trans %}Click <em>Save</em>. You will see the content displayed on a page.{% endtrans %}</li>
</ol>
<h2>{% trans %}Additional resources{% endtrans %}</h2>
<ul>
  <li><a href=\"https://www.drupal.org/docs/user_guide/en/content-chapter.html\">{% trans %}Basic Page Management (Drupal User Guide){% endtrans %}</a></li>
  <li><a href=\"https://www.drupal.org/docs/user_guide/en/content-create.html\">{% trans %}Creating a Content Item (Drupal User Guide){% endtrans %}</a></li>
</ul>", "@help_topics/node.creating_content.html.twig", "/Users/abuyahia/Desktop/Sites/sidan/web/core/modules/node/help_topics/node.creating_content.html.twig");
    }
    
    public function checkSecurity()
    {
        static $tags = ["set" => 8, "trans" => 9];
        static $filters = ["escape" => 18];
        static $functions = ["render_var" => 11, "help_route_link" => 11, "help_topic_link" => 16];

        try {
            $this->sandbox->checkSecurity(
                ['set', 'trans'],
                ['escape'],
                ['render_var', 'help_route_link', 'help_topic_link'],
                $this->source
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
