<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @help_topics/core.ui_components.html.twig */
class __TwigTemplate_8e28f5b5c3967598ab839c6b5958c015 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
        $this->sandbox = $this->extensions[SandboxExtension::class];
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 7
        $context["accessibility_topic"] = $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar($this->extensions['Drupal\help\HelpTwigExtension']->getTopicLink("core.ui_accessibility"));
        // line 8
        $context["settings_tray_topic"] = $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar($this->extensions['Drupal\help\HelpTwigExtension']->getTopicLink("core.settings_tray"));
        // line 9
        $context["admin_link"] = $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar($this->extensions['Drupal\help\HelpTwigExtension']->getRouteLink("/admin", "system.admin"));
        // line 10
        yield "<h2>";
        yield t("What administrative interface components are available?", []);
        yield "</h2>
<p>";
        // line 11
        yield t("The following administrative interface components are provided by the core software and its modules (some contributed modules offer additional functionality):", []);
        yield "</p>
<ul>
  <li>";
        // line 13
        yield t("Accessibility features, to enable all users to perform administrative tasks. See @accessibility_topic for more information.", ["@accessibility_topic" => $this->env->getExtension(\Drupal\Core\Template\TwigExtension::class)->renderVar(($context["accessibility_topic"] ?? null)), ]);
        yield "</li>
  <li>";
        // line 14
        yield t("A menu system, which you can navigate to find pages for administrative tasks. The core Toolbar module displays this menu on the top or left side of the page (right side in right-to-left languages). There are also contributed module replacements for the core Toolbar module, with additional features, such as the <a href=\"https://www.drupal.org/project/admin_toolbar\">Admin Toolbar module</a>.", []);
        yield "</li>
  <li>";
        // line 15
        yield t("The core Shortcuts module enhances the toolbar with a configurable list of links to commonly-used tasks.", []);
        yield "</li>
  <li>";
        // line 16
        yield t("If you install the core Contextual Links module, non-administrative pages will contain links leading to related administrative tasks.", []);
        yield "</li>
  <li>";
        // line 17
        yield t("In-place or <em>quick</em> editing. In-place editing of configuration is provided by the core Settings Tray module. See @settings_tray_topic for more information.", ["@settings_tray_topic" => $this->env->getExtension(\Drupal\Core\Template\TwigExtension::class)->renderVar(($context["settings_tray_topic"] ?? null)), ]);
        yield "</li>
  <li>";
        // line 18
        yield t("The core Help module displays help topics, and provides a Help block that can be placed on administrative pages to provide an overview of their functionality.", []);
        yield "</li>
</ul>
<h2>";
        // line 20
        yield t("What are the sections of the administrative menu?", []);
        yield "</h2>
<p>";
        // line 21
        yield t("The administrative menu, which you can navigate by visiting <em>@admin_link</em> on your site or by using an administrative toolbar, has the following sections (some may not be available, depending on which modules are currently installed on your site, and your permissions):", ["@admin_link" => $this->env->getExtension(\Drupal\Core\Template\TwigExtension::class)->renderVar(($context["admin_link"] ?? null)), ]);
        yield "</p>
<ul>
  <li>";
        // line 23
        yield t("<strong>Content:</strong> Find, manage, and create new pages; manage comments and files.", []);
        yield "</li>
  <li>";
        // line 24
        yield t("<strong>Structure:</strong> Place and edit blocks, set up content types and fields, configure menus, administer taxonomy, and configure some contributed modules.", []);
        yield "</li>
  <li>";
        // line 25
        yield t("<strong>Appearance:</strong> Switch between themes, install themes, and update existing themes.", []);
        yield "</li>
  <li>";
        // line 26
        yield t("<strong>Extend:</strong> Update, install, and uninstall modules.", []);
        yield "</li>
  <li>";
        // line 27
        yield t("<strong>Configuration:</strong> Configure the settings for various site functionality, including some contributed modules.", []);
        yield "</li>
  <li>";
        // line 28
        yield t("<strong>People:</strong> Manage user accounts and permissions.", []);
        yield "</li>
  <li>";
        // line 29
        yield t("<strong>Reports:</strong> Display information about site security, necessary updates, and site activity.", []);
        yield "</li>
  <li>";
        // line 30
        yield t("<strong>Help:</strong> Get help on using the administrative interface.", []);
        yield "</li>
</ul>
<h2>";
        // line 32
        yield t("Administrative interface overview", []);
        yield "</h2>
<p>";
        // line 33
        yield t("Install the core modules mentioned above to use the corresponding aspect of the administrative interface. See the related topics listed below for more details on some aspects of the administrative interface.", []);
        yield "</p>";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@help_topics/core.ui_components.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  131 => 33,  127 => 32,  122 => 30,  118 => 29,  114 => 28,  110 => 27,  106 => 26,  102 => 25,  98 => 24,  94 => 23,  89 => 21,  85 => 20,  80 => 18,  76 => 17,  72 => 16,  68 => 15,  64 => 14,  60 => 13,  55 => 11,  50 => 10,  48 => 9,  46 => 8,  44 => 7,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% line 7 %}{% set accessibility_topic = render_var(help_topic_link('core.ui_accessibility')) %}
{% set settings_tray_topic = render_var(help_topic_link('core.settings_tray')) %}
{% set admin_link = render_var(help_route_link('/admin', 'system.admin')) %}
<h2>{% trans %}What administrative interface components are available?{% endtrans %}</h2>
<p>{% trans %}The following administrative interface components are provided by the core software and its modules (some contributed modules offer additional functionality):{% endtrans %}</p>
<ul>
  <li>{% trans %}Accessibility features, to enable all users to perform administrative tasks. See {{ accessibility_topic }} for more information.{% endtrans %}</li>
  <li>{% trans %}A menu system, which you can navigate to find pages for administrative tasks. The core Toolbar module displays this menu on the top or left side of the page (right side in right-to-left languages). There are also contributed module replacements for the core Toolbar module, with additional features, such as the <a href=\"https://www.drupal.org/project/admin_toolbar\">Admin Toolbar module</a>.{% endtrans %}</li>
  <li>{% trans %}The core Shortcuts module enhances the toolbar with a configurable list of links to commonly-used tasks.{% endtrans %}</li>
  <li>{% trans %}If you install the core Contextual Links module, non-administrative pages will contain links leading to related administrative tasks.{% endtrans %}</li>
  <li>{% trans %}In-place or <em>quick</em> editing. In-place editing of configuration is provided by the core Settings Tray module. See {{ settings_tray_topic }} for more information.{% endtrans %}</li>
  <li>{% trans %}The core Help module displays help topics, and provides a Help block that can be placed on administrative pages to provide an overview of their functionality.{% endtrans %}</li>
</ul>
<h2>{% trans %}What are the sections of the administrative menu?{% endtrans %}</h2>
<p>{% trans %}The administrative menu, which you can navigate by visiting <em>{{ admin_link }}</em> on your site or by using an administrative toolbar, has the following sections (some may not be available, depending on which modules are currently installed on your site, and your permissions):{% endtrans %}</p>
<ul>
  <li>{% trans %}<strong>Content:</strong> Find, manage, and create new pages; manage comments and files.{% endtrans %}</li>
  <li>{% trans %}<strong>Structure:</strong> Place and edit blocks, set up content types and fields, configure menus, administer taxonomy, and configure some contributed modules.{% endtrans %}</li>
  <li>{% trans %}<strong>Appearance:</strong> Switch between themes, install themes, and update existing themes.{% endtrans %}</li>
  <li>{% trans %}<strong>Extend:</strong> Update, install, and uninstall modules.{% endtrans %}</li>
  <li>{% trans %}<strong>Configuration:</strong> Configure the settings for various site functionality, including some contributed modules.{% endtrans %}</li>
  <li>{% trans %}<strong>People:</strong> Manage user accounts and permissions.{% endtrans %}</li>
  <li>{% trans %}<strong>Reports:</strong> Display information about site security, necessary updates, and site activity.{% endtrans %}</li>
  <li>{% trans %}<strong>Help:</strong> Get help on using the administrative interface.{% endtrans %}</li>
</ul>
<h2>{% trans %}Administrative interface overview{% endtrans %}</h2>
<p>{% trans %}Install the core modules mentioned above to use the corresponding aspect of the administrative interface. See the related topics listed below for more details on some aspects of the administrative interface.{% endtrans %}</p>", "@help_topics/core.ui_components.html.twig", "/Users/abuyahia/Desktop/Sites/sidan/web/core/modules/help/help_topics/core.ui_components.html.twig");
    }
    
    public function checkSecurity()
    {
        static $tags = ["set" => 7, "trans" => 10];
        static $filters = ["escape" => 13];
        static $functions = ["render_var" => 7, "help_topic_link" => 7, "help_route_link" => 9];

        try {
            $this->sandbox->checkSecurity(
                ['set', 'trans'],
                ['escape'],
                ['render_var', 'help_topic_link', 'help_route_link'],
                $this->source
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
