<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @help_topics/core.config_overview.html.twig */
class __TwigTemplate_ede2c2b1283207d1c1f20e7f142c24ea extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
        $this->sandbox = $this->extensions[SandboxExtension::class];
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 10
        yield "<h2>";
        yield t("What is the configuration system?", []);
        yield "</h2>
<p>";
        // line 11
        yield t("The configuration system provides the ability for administrators to customize the site, and to move and synchronize configuration changes between development sites and the live site. It does this in 2 ways:", []);
        yield "</p>
<ol>
  <li>";
        // line 13
        yield t("Providing storage for configuration", []);
        yield "</li>
  <li>";
        // line 14
        yield t("Providing a process in which configuration changes can be imported and exported between instances of the same site; for example, from \"dev\" to \"staging\" to \"live\"", []);
        yield "</li>
</ol>
<h2>";
        // line 16
        yield t("What is configuration data?", []);
        yield "</h2>
<p>";
        // line 17
        yield t("Configuration data describes settings that define how your site behaves or is displayed. For example, when a site administrator updates settings using an administrative form, these settings are stored as configuration data. Configuration data describes settings as simple as a site name and as complex as a view or image style.", []);
        yield "</p>
<h2>";
        // line 18
        yield t("What kinds of configuration are there?", []);
        yield "</h2>
<dl>
  <dt>";
        // line 20
        yield t("Active configuration", []);
        yield "</dt>
  <dd>";
        // line 21
        yield t("Active configuration is the current working configuration of a site. Storage of active configuration is defined by the site, and resides in the database by default.", []);
        yield "</dd>
  <dt>";
        // line 22
        yield t("Simple configuration", []);
        yield "</dt>
  <dd>";
        // line 23
        yield t("A simple configuration item is a group of settings, such as the settings for a module or theme. Each simple configuration item has its own unique structure.", []);
        yield "</dd>
  <dt>";
        // line 24
        yield t("Configuration entities", []);
        yield "</dt>
  <dd>";
        // line 25
        yield t("Configuration entities are user-defined configuration items grouped by type, such as views, image styles, and content types. Each configuration entity within a type has a similar structure.", []);
        yield "</dd>
  <dt>";
        // line 26
        yield t("Default configuration", []);
        yield "</dt>
  <dd>";
        // line 27
        yield t("Default configuration can be defined by a module, theme, or installation profile in its <em>config/install</em> or <em>config/optional</em> directories. Configuration is provided in YAML files (file extension .yml); YAML is a human-readable data serialization standard that is used by the core software for several purposes. Once the default configuration has been imported into the site's active configuration (through installing the extension), that configuration is owned by the site, not the extension. This means that future updates of the extension will not override the site's active configuration for that extension.", []);
        yield "</dd>
</dl>
<h2>";
        // line 29
        yield t("What is configuration synchronization?", []);
        yield "</h2>
<p>";
        // line 30
        yield t("Configuration synchronization is the process of exporting and importing configuration to keep configuration synchronized between different versions of a site; for example, between a development site and the live site.", []);
        yield "</p>
<p>";
        // line 31
        yield t("Each site has unique identifier, also called a <em>UUID</em>, which identifies the site to the system in any instance of the site, as long as the site instances have been reproduced as clones (cloning is when the codebase and database are copied to create a new site instance). When site instances are cloned, a \"dev\" instance of the site has the same UUID as the \"live\" instance. When site instances share the same UUID, configuration can be exported from one instance to another.", []);
        yield "</p>
<p>";
        // line 32
        yield t("The following list contains terms and concepts related to configuration synchronization:", []);
        yield "</p>
<dl>
  <dt>";
        // line 34
        yield t("Exported configuration", []);
        yield "</dt>
  <dd>";
        // line 35
        yield t("When configuration is exported, the active configuration is exported as a set of files in YAML format. When using the <em>Configuration synchronization</em> administrative UI, configuration can be exported as a full-export or single-item archive. This archive can then be imported into the destination site instance.", []);
        yield "</dd>
  <dt>";
        // line 36
        yield t("Imported configuration", []);
        yield "</dt>
  <dd>";
        // line 37
        yield t("Imported configuration is configuration that has been exported from another instance of the site (the \"source\") and is now being imported into another site instance (the \"destination\"), thereby updating its active configuration to match the imported configuration data set.", []);
        yield "</dd>
  <dt>";
        // line 38
        yield t("Configuration sync directory", []);
        yield "</dt>
  <dd>";
        // line 39
        yield t("The configuration sync directory location is set in the site's <em>settings.php</em> file. When configuration is exported, the active configuration is exported and described in YAML files which are stored in the configuration sync directory. After the first export, the system compares the site's active configuration with the configuration data in the sync directory and will only export active configuration items that are different than their counterparts in the sync directory.", []);
        yield "</dd>
</dl>
<h2>";
        // line 41
        yield t("Managing configuration overview", []);
        yield "</h2>
<p>";
        // line 42
        yield t("Configuration management tasks, such as exporting or importing configuration and synchronizing configuration, can be done either through the administrative UI provided by the core Configuration Manager module or a command-line interface (CLI) tool. Defining a configuration sync directory path other than the default value requires read/write access to the site's <em>settings.php</em> file.", []);
        yield "</p>
<p>";
        // line 43
        yield t("Most modules and themes also provide settings forms for updating the configuration they provide. See the related topics listed below for specific tasks.", []);
        yield "</p>
<h2>";
        // line 44
        yield t("Additional resources", []);
        yield "</h2>
<ul>
  <li>";
        // line 46
        yield t("<a href=\"https://www.drupal.org/docs/configuration-management/workflow-using-drush\">Configuration Management: Workflow using Drush</a>", []);
        yield "</li>
  <li>";
        // line 47
        yield t("<a href=\"https://www.drupal.org/docs/user_guide/en/understanding-data.html\">Concept: Types of Data (Drupal User Guide)</a>", []);
        yield "</li>
  <li>";
        // line 48
        yield t("<a href=\"https://www.drupal.org/docs/user_guide/en/install-dev-sites.html\">Concept: Development Sites (Drupal User Guide)</a>", []);
        yield "</li>
  <li>";
        // line 49
        yield t("<a href=\"https://www.drupal.org/docs/user_guide/en/install-dev-making.html\">Making a Development Site (Drupal User Guide)</a>", []);
        yield "</li>
</ul>";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@help_topics/core.config_overview.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  180 => 49,  176 => 48,  172 => 47,  168 => 46,  163 => 44,  159 => 43,  155 => 42,  151 => 41,  146 => 39,  142 => 38,  138 => 37,  134 => 36,  130 => 35,  126 => 34,  121 => 32,  117 => 31,  113 => 30,  109 => 29,  104 => 27,  100 => 26,  96 => 25,  92 => 24,  88 => 23,  84 => 22,  80 => 21,  76 => 20,  71 => 18,  67 => 17,  63 => 16,  58 => 14,  54 => 13,  49 => 11,  44 => 10,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% line 10 %}<h2>{% trans %}What is the configuration system?{% endtrans %}</h2>
<p>{% trans %}The configuration system provides the ability for administrators to customize the site, and to move and synchronize configuration changes between development sites and the live site. It does this in 2 ways:{% endtrans %}</p>
<ol>
  <li>{% trans %}Providing storage for configuration{% endtrans %}</li>
  <li>{% trans %}Providing a process in which configuration changes can be imported and exported between instances of the same site; for example, from \"dev\" to \"staging\" to \"live\"{% endtrans %}</li>
</ol>
<h2>{% trans %}What is configuration data?{% endtrans %}</h2>
<p>{% trans %}Configuration data describes settings that define how your site behaves or is displayed. For example, when a site administrator updates settings using an administrative form, these settings are stored as configuration data. Configuration data describes settings as simple as a site name and as complex as a view or image style.{% endtrans %}</p>
<h2>{% trans %}What kinds of configuration are there?{% endtrans %}</h2>
<dl>
  <dt>{% trans %}Active configuration{% endtrans %}</dt>
  <dd>{% trans %}Active configuration is the current working configuration of a site. Storage of active configuration is defined by the site, and resides in the database by default.{% endtrans %}</dd>
  <dt>{% trans %}Simple configuration{% endtrans %}</dt>
  <dd>{% trans %}A simple configuration item is a group of settings, such as the settings for a module or theme. Each simple configuration item has its own unique structure.{% endtrans %}</dd>
  <dt>{% trans %}Configuration entities{% endtrans %}</dt>
  <dd>{% trans %}Configuration entities are user-defined configuration items grouped by type, such as views, image styles, and content types. Each configuration entity within a type has a similar structure.{% endtrans %}</dd>
  <dt>{% trans %}Default configuration{% endtrans %}</dt>
  <dd>{% trans %}Default configuration can be defined by a module, theme, or installation profile in its <em>config/install</em> or <em>config/optional</em> directories. Configuration is provided in YAML files (file extension .yml); YAML is a human-readable data serialization standard that is used by the core software for several purposes. Once the default configuration has been imported into the site's active configuration (through installing the extension), that configuration is owned by the site, not the extension. This means that future updates of the extension will not override the site's active configuration for that extension.{% endtrans %}</dd>
</dl>
<h2>{% trans %}What is configuration synchronization?{% endtrans %}</h2>
<p>{% trans %}Configuration synchronization is the process of exporting and importing configuration to keep configuration synchronized between different versions of a site; for example, between a development site and the live site.{% endtrans %}</p>
<p>{% trans %}Each site has unique identifier, also called a <em>UUID</em>, which identifies the site to the system in any instance of the site, as long as the site instances have been reproduced as clones (cloning is when the codebase and database are copied to create a new site instance). When site instances are cloned, a \"dev\" instance of the site has the same UUID as the \"live\" instance. When site instances share the same UUID, configuration can be exported from one instance to another.{% endtrans %}</p>
<p>{% trans %}The following list contains terms and concepts related to configuration synchronization:{% endtrans %}</p>
<dl>
  <dt>{% trans %}Exported configuration{% endtrans %}</dt>
  <dd>{% trans %}When configuration is exported, the active configuration is exported as a set of files in YAML format. When using the <em>Configuration synchronization</em> administrative UI, configuration can be exported as a full-export or single-item archive. This archive can then be imported into the destination site instance.{% endtrans %}</dd>
  <dt>{% trans %}Imported configuration{% endtrans %}</dt>
  <dd>{% trans %}Imported configuration is configuration that has been exported from another instance of the site (the \"source\") and is now being imported into another site instance (the \"destination\"), thereby updating its active configuration to match the imported configuration data set.{% endtrans %}</dd>
  <dt>{% trans %}Configuration sync directory{% endtrans %}</dt>
  <dd>{% trans %}The configuration sync directory location is set in the site's <em>settings.php</em> file. When configuration is exported, the active configuration is exported and described in YAML files which are stored in the configuration sync directory. After the first export, the system compares the site's active configuration with the configuration data in the sync directory and will only export active configuration items that are different than their counterparts in the sync directory.{% endtrans %}</dd>
</dl>
<h2>{% trans %}Managing configuration overview{% endtrans %}</h2>
<p>{% trans %}Configuration management tasks, such as exporting or importing configuration and synchronizing configuration, can be done either through the administrative UI provided by the core Configuration Manager module or a command-line interface (CLI) tool. Defining a configuration sync directory path other than the default value requires read/write access to the site's <em>settings.php</em> file.{% endtrans %}</p>
<p>{% trans %}Most modules and themes also provide settings forms for updating the configuration they provide. See the related topics listed below for specific tasks.{% endtrans %}</p>
<h2>{% trans %}Additional resources{% endtrans %}</h2>
<ul>
  <li>{% trans %}<a href=\"https://www.drupal.org/docs/configuration-management/workflow-using-drush\">Configuration Management: Workflow using Drush</a>{% endtrans %}</li>
  <li>{% trans %}<a href=\"https://www.drupal.org/docs/user_guide/en/understanding-data.html\">Concept: Types of Data (Drupal User Guide)</a>{% endtrans %}</li>
  <li>{% trans %}<a href=\"https://www.drupal.org/docs/user_guide/en/install-dev-sites.html\">Concept: Development Sites (Drupal User Guide)</a>{% endtrans %}</li>
  <li>{% trans %}<a href=\"https://www.drupal.org/docs/user_guide/en/install-dev-making.html\">Making a Development Site (Drupal User Guide)</a>{% endtrans %}</li>
</ul>", "@help_topics/core.config_overview.html.twig", "/Users/abuyahia/Desktop/Sites/sidan/web/core/modules/help/help_topics/core.config_overview.html.twig");
    }
    
    public function checkSecurity()
    {
        static $tags = ["trans" => 10];
        static $filters = [];
        static $functions = [];

        try {
            $this->sandbox->checkSecurity(
                ['trans'],
                [],
                [],
                $this->source
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
